SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_Sp_ResetProjectData]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_Sp_ResetProjectData]
GO
CREATE PROCEDURE [dbo].[VX_Sp_ResetProjectData]
AS
  EXEC Sp_resetbuffernew
  DELETE FROM Note
  DELETE FROM HistoricResponse
  DELETE FROM Historic
  DELETE FROM Stratum
  DELETE FROM TimeSlotHit
  DELETE FROM Response
  DELETE FROM ImportHistory
  DELETE FROM CaseActionHistoryDetail
  DELETE FROM CaseActionHistory
  -- Reset indentity
  DBCC CHECKIDENT ('CaseActionHistory', RESEED, 0);
  DBCC CHECKIDENT ('CaseActionHistoryDetail', RESEED, 0);
  DELETE FROM RespondentPIN
  DELETE FROM RespondentState
  DELETE FROM ImportedFields
  DELETE FROM respondent
  DELETE FROM RespondentModifLog
  DELETE FROM ResponseModifLog
  DELETE FROM TIMESLOTHIT
  DELETE FROM CAPI_CasesToSendBack

  -- DE12699 Reset project data does not reset the A4S ID table
  DELETE FROM IS_RespondentSync 

  UPDATE quota
  SET    qtonline = 0,
         qtunused = 0,
         qtfrequence = 0,
         qtstatustemp = 0,
		 FrequencyForThePeriod = 0
  
  UPDATE quotasagent
  SET    Frequency = 0
  
  UPDATE sequence
  SET    Value = 0
  WHERE Name = 'Respondent'

 /*DE659*/
 INSERT INTO [ResetDataHistory]
 (Description,ResetDate)
 SELECT 'Data was reset on the server',GETUTCDATE()
GO
